#include <bits/stdc++.h>

using namespace std;

const int digits = 31;
const int max_n = 2e5 + 5;
int suff[digits][max_n];


int num_inv(int num){
    return ((~num) ^ (1 << 31));
}


struct Node{
    int val;
    Node *zero;
    Node *one;
};

Node *newNode(int ct){
    Node *temp = new Node;
    temp->val = ct;
    temp->zero = NULL;
    temp->one = NULL;
    return temp;
}

void add(int ct, int num, int depth, Node *node){
    node->val = ct;
    if (depth > digits) return;
    if (num & (1 << (digits - depth))){
        if (node->one == NULL) node->one = newNode(ct);
        add(ct, num, depth + 1, node->one);
    }
    else{
        if (node->zero == NULL) node->zero = newNode(ct);
        add(ct, num, depth + 1, node->zero);
    }
}


int find_best(int ct, int goal, int depth, Node *node){
    if (depth > digits) return 0;
    bool to_visit;
    if (goal & (1 << (digits - depth))){
        if (node->one != NULL){
            if (ct > node->one->val) to_visit = true;
            else to_visit = false;
        }
        else to_visit = false;
    }
    else{
        if (node->zero != NULL){
            if (ct > node->zero->val) to_visit = false;
            else to_visit = true;
        }
        else to_visit = true;
    }
    int ans;
    if (to_visit){
        ans = find_best(ct, goal, depth + 1, node->one);
        ans |= (1 << (digits - depth));
    }
    else{
        ans = find_best(ct, goal, depth + 1, node->zero);
    }
    return ans;
}


int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    Node *root = newNode(0);
    int n;
    cin >> n;
    vector<int> a(n), b(n);
    for (int i = 0; i < n; i++) cin >> a[i];
    for (int i = 0; i < n; i++) cin >> b[i];
    for (int bi = 0; bi < digits; bi++) suff[bi][n] = n;
    for (int bi = 0; bi < digits; bi++){
        for (int i = n - 1; i >= 0; i--){
            if (b[i] & (1 << bi)) suff[bi][i] = suff[bi][i + 1];
            else suff[bi][i] = i;
        }
    }
    vector<int> pref_xor(n + 1);
    for (int i = 0; i < n; i++) pref_xor[i + 1] = pref_xor[i] ^ a[i];
    long long int best_ans = 0;
    int and_num;
    for (int l = n - 1; l >= 0; l--){
        and_num = b[l];
        vector<int> to_visit;
        for (int bi = 0; bi < digits; bi++)
            if (b[l] & (1 << bi))
                to_visit.push_back(suff[bi][l]);
        sort(to_visit.begin(), to_visit.end());
        add(l, pref_xor[l + 1], 1, root);
        int inv = num_inv(pref_xor[l]);
        int prev = -1;
        for (int r : to_visit){
            if (r != prev){
                best_ans = max(best_ans, (pref_xor[l] ^ find_best(r, inv, 1, root)) * 1LL * and_num);
            }
            prev = r;
            and_num &= b[r]; // this should only lose the bit that we want to lose
        }
    }
    cout << best_ans << endl;
    return 0;
}